<?php

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Aastra XML API Classes - AastraIPPhone
#
# AastraIPPhone is the root class for all the Aastra XML objects.
#
# Public methods
#     setTitle(Title) to setup the title of an object 
#     setDestroyOnExit() to set DestroyonExit parameter to 'yes', 'no' by default (optional)
#     setBeep() to enable a notification beep with the object (optional)
#     setRefresh(timeout,URL) to add Refresh parameters to the object (optional)
#     addSoftkey(index,label,uri) to add custom soktkeys to the object (optional)
#     output() to display the object
#
###################################################################################################

require_once('AastraIPPhoneSoftkeyEntry.class.php');

class AastraIPPhone {
	var $_entries;
	var $_softkeys;
	var $_title;
	var $_destroyOnExit='';
	var $_refreshTimeout=0;
	var $_refreshURL='';
       var $_beep='';

	function AastraIPPhone()
	{
		$this->_entries = array();
		$this->_softkeys = array();
		$this->_title = '';
	}

	function setTitle($title)
	{
		$this->_title = $title;
	}

	function setRefresh($timeout,$URL)
	{
		$this->_refreshTimeout = $timeout;
		$this->_refreshURL = $URL;
	}

	function setBeep() 
	{
		$this->_beep='yes';
	}

	function setDestroyOnExit() 
	{
		$this->_destroyOnExit='yes';
	}

	function output()
	{
		header("Content-type: text/xml");
		if (($this->_refreshTimeout!=0) and ($this->_refreshURL!='')) header("Refresh: ".$this->_refreshTimeout."; url=".$this->_refreshURL);
		$output=$this->render();
		header("Content-Length: ".strlen($output));
		echo($output);
	}

	function addSoftkey($index, $label, $uri)
	{
		$this->_softkeys[] = new AastraIPPhoneSoftkeyEntry($index, $label, $uri);
	}

	function escape($string)
	{
		return(str_replace(
			array('<', '>', '&'),
			array('&lt;', '&gt;', '&amp;'),
			$string
		));
	}
}
?>
