<?php

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
########################################################################################################
# Aastra XML API Classes - AastraIPPhoneExecute
#
# AastraIPPhoneTextMenu object.
#
# Public methods
#
# Inherited from AastraIPPhone
#     output() to display the object
#     setBeep() to enable a notification beep with the object (optional)
#
# Specific to the object
#     addEntry(url) to add an action to be executed.
#
# Example
#     require_once('AastraIPPhoneExecute.class.php');
#     $execute = new AastraIPPhoneExecute();
#     $execute->addEntry('http://myserver.com/script.php?choice=2');
#     $execute->addEntry('Command: Reset');
#     $execute->output();
#
########################################################################################################

require_once('AastraIPPhone.class.php');
require_once('AastraIPPhoneExecuteEntry.class.php');

class AastraIPPhoneExecute extends AastraIPPhone {
	
	function addEntry($url)
	{
		$this->_entries[] = new AastraIPPhoneExecuteEntry($url);
	}

	function render()
	{
		$title = $this->escape($this->_title);
		$out = "<AastraIPPhoneExecute";
		if($this->_beep=='yes') $out .= " Beep=\"yes\"";
		$out .= ">\n";
		foreach ($this->_entries as $entry) $out .= $entry->render();
		$out .= "</AastraIPPhoneExecute>\n";
		return($out);
	}
}
?>
