<?

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Aastra XML API Classes - AastraIPPhoneInputScreen
#
# AastraIPPhoneInputScreen object.
#
# Public methods
#
# Inherited from AastraIPPhone
#     setTitle(Title) to setup the title of an object 
#     setDestroyOnExit() to set DestroyonExit parameter to 'yes', 'no' by default (optional)
#     setBeep() to enable a notification beep with the object (optional)
#     addSoftkey(index,label,uri) to add custom softkeys to the object (optional)
#     output() to display the object
#
# Specific to the object
#     setURL() to set the URL to called after the input
#     setType(type) to set type of input ('IP', 'string'or 'number'), 'string'by default
#     setDefault(default) to set default value for the input (optional)
#     setParameter(param) to set the parameter name to be parsed after the input
#     setPassword() to set the Password parameter to 'yes', 'no' by default (optional)
#     setNotEditable() to set the editable parameter to 'no', 'yes' by default (optional)
#     setEditable() is now replaced by setNotEditable but kept for compatibility reasons (optional)
#     setPrompt(prompt) to set the prompt to be displayed for the input.
#
# Example
#     require_once('AastraIPPhoneInputScreen.class.php');
#     $input = new AastraIPPhoneInputScreen();
#     $input->setTitle('Title');
#     $input->setPrompt('Enter your password');
#     $input->setParameter('param');
#     $input->setType('string');
#     $input->setURL('http://myserver.com/script.php');
#     $input->setPassword();
#     $input->setDefault('');
#     $input->setDestroyOnExit();
#     $input->setNotEditable();
#     $input->addSoftkey('1','Label 1','http://myserver.com/script.php?action=1');
#     $input->addSoftkey('6','Exit','SoftKey:Exit');
#     $input->output();
#
########################################################################################################

require_once('AastraIPPhone.class.php');

class AastraIPPhoneInputScreen extends AastraIPPhone {
	var $_url;
	var $_type='string';
	var $_parameter;
	var $_prompt;
	var $_editable='';
	var $_default='';
	var $_password='';

	function setURL($url) 
	{
		$this->_url=$url;
	}
	function setType($type) 
	{
		$this->_type=$type;
	}

	function setEditable() 
	{
		$this->_editable='no';
	}

	function setNotEditable() 
	{
		$this->_editable='no';
	}

	function setDefault($default) 
	{
		$this->_default=$default;
	}

	function setParameter($parameter) 
	{
		$this->_parameter=$parameter;
	}

	function setPassword() 
	{
		$this->_password='yes';
	}

	function setPrompt($prompt) 
	{
		$this->_prompt=$prompt;
	}

	function render()
	{
		$title = $this->escape($this->_title);
		$prompt = $this->escape($this->_prompt);
		$url = $this->escape($this->_url);
		$out = '';
		$out .= "<AastraIPPhoneInputScreen type=\"$this->_type\"";
		if($this->_password == 'yes') $out .= " password=\"yes\"";
		if($this->_destroyOnExit == 'yes') $out .= " destroyOnExit=\"yes\"";
		if($this->_editable == 'no') $out .= " editable=\"no\"";
		if($this->_beep=='yes') $out .= " Beep=\"yes\"";
		$out .= ">\n";
		$out .= "<Title>{$title}</Title>\n";
		$out .= "<Prompt>{$prompt}</Prompt>\n";
		$out .= "<URL>{$url}</URL>\n";
		$out .= "<Parameter>{$this->_parameter}</Parameter>\n";
		$out .= "<Default>{$this->_default}</Default>\n";
		foreach ($this->_softkeys as $softkey) $out .= $softkey->render();
		$out .= "</AastraIPPhoneInputScreen>\n";
		return $out;
	}
}
?>
