<?php

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Aastra XML API Classes - AastraIPPhoneStatus
#
# AastraIPPhoneStatus object.
#
# Public methods
#
# Inherited from AastraIPPhone
#     output() to display the object
#     setBeep() to enable a notification beep with the object (optional)
#
# Specific to the object
#     setSession(session) to setup the session ID
#     addEntry(index,message,type,timeout) to add a message to be displayed on the idle screen.
#
# Example
#     require_once('AastraIPPhoneStatus.class.php');
#     $status = new AastraIPPhoneStatus();
#     $status->setSession('Session');
#     $status->setBeep();
#     $status->addEntry('1','Message 1','',0);
#     $status->addEntry('2','Message 2','alert',5);
#     $status->output();
#
########################################################################################################

require_once('AastraIPPhone.class.php');
require_once('AastraIPPhoneStatusEntry.class.php');

class AastraIPPhoneStatus extends AastraIPPhone {
	var $_session;

	function setSession($session) 
	{
		$this->_session=$session;
	}

	function addEntry($index, $message, $type='', $timeout=NULL)
	{
		$this->_entries[] = new AastraIPPhoneStatusEntry($index, $message, $type, $timeout);
	}

	function render()
	{
		$session = $this->escape($this->_session);
		$out = "<AastraIPPhoneStatus";
		if($this->_beep=='yes') $out .= " Beep=\"yes\"";
		$out .= ">\n";
		$out .= "<Session>".$session."</Session>\n";
		foreach ($this->_entries as $entry) $out .= $entry->render();
		$out .= "</AastraIPPhoneStatus>\n";
		return($out);
	}
}
?>
