<?php

##################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##################################################################################################
# Aastra XML API Classes - AastraIPPhoneStatusEntry
# Aastra 480i Firmware 1.4.1 or better
#
# Internal class for AastraIPPhoneStatus object.
##################################################################################################

class AastraIPPhoneStatusEntry extends AastraIPPhone {
	var $_index;
	var $_message;
       var $_type='';
       var $_timeout=NULL;

	function AastraIPPhoneStatusEntry($index, $message, $type, $timeout)
	{
		$this->_index=$index;
		$this->_message=$message;
		$this->_type=$type;
		$this->_timeout=$timeout;
	}

	function render()
	{
		$index = $this->escape($this->_index);
		$message = $this->escape($this->_message);
		$type = $this->_type;
		$timeout = $this->_timeout;
		$xml = "<Message index=\"{$index}\"";
		if ($type!='') 
			{
			$xml .= " type=\"{$type}\"";
			if ($timeout!=NULL) $xml .= " Timeout=\"{$timeout}\"";
			}
		$xml .= ">{$message}</Message>\n";
		return($xml);
	}
}
?>