<?php

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Aastra XML API Classes - AastraIPPhoneTextMenu
#
# AastraIPPhoneTextMenu object.
#
# Public methods
#
# Inherited from AastraIPPhone
#     setTitle(Title) to setup the title of an object 
#     setDestroyOnExit() to set DestroyOnExit parameter to "yes" (optional)
#     setBeep() to enable a notification beep with the object (optional)
#     addSoftkey(index,label,uri) to add custom softkeys to the object (optional)
#     setRefresh(timeout,URL) to add Refresh parameters to the object (optional)
#     output() to display the object
#
# Specific to the object
#     setDestroyOnExit() to set DestroyOnExit parameter to "yes", optional
#     addEntry(name,url,selection) to add an element in the list to be displayed, at 
#     least one is needed.
#     natsortbyname() to order the list
#
# Example
#     require_once('AastraIPPhoneTextMenu.class.php');
#     $menu = new AastraIPPhoneTextMenu();
#     $menu->setTitle('Title');
#     $menu->setDestroyOnExit();
#     $menu->setDefaultIndex();
#     $menu->addEntry('Choice 2', 'http://myserver.com/script.php?choice=2','');
#     $menu->addEntry('Choice 1', 'http://myserver.com/script.php?choice=1','');
#     $menu->addEntry('Choice 3', 'http://myserver.com/script.php?choice=3','');
#     $menu->natsortByName();
#     $menu->addSoftkey('1','Label 1','http://myserver.com/script.php?action=1');
#     $menu->addSoftkey('6','Exit','SoftKey:Exit');
#     $menu->output();
#
####################################################################################################

require_once('AastraIPPhone.class.php');
require_once('AastraIPPhoneTextMenuEntry.class.php');

class AastraIPPhoneTextMenu extends AastraIPPhone {
	var $_defaultIndex="";

	function setDefaultIndex($defaultIndex)
	{
		$this->_defaultIndex = $defaultIndex;
	}

	function addEntry($name, $url, $selection=NULL)
	{
		$this->_entries[] = new AastraIPPhoneTextMenuEntry($name, $url, $selection);
	}

	function natsortByName()
	{
		$tmpary = array();
		foreach ($this->_entries as $id => $entry) {
			$tmpary[$id] = $entry->getName();
		}
		natsort($tmpary);
		foreach ($tmpary as $id => $name) {
			$newele[] = $this->_entries[$id];
		}
		$this->_entries = $newele;
	}

	function render()
	{
		$title = $this->escape($this->_title);
		$out = "<AastraIPPhoneTextMenu ";
		if ($this->_destroyOnExit=='yes') $out .= "destroyOnExit=\"yes\" ";
		if ($this->_defaultIndex!="") $out .= "defaultIndex=\"{$this->_defaultIndex}\"";
		if($this->_beep=='yes') $out .= " Beep=\"yes\"";
		$out .= ">\n";
		$out .= "<Title>".$title."</Title>\n";
		$index=0;
		foreach ($this->_entries as $entry) {
			if($index<15) $out .= $entry->render();
			$index++;
		}
		foreach ($this->_softkeys as $softkey) $out .= $softkey->render();
		$out .= "</AastraIPPhoneTextMenu>\n";
		return($out);
	}
}
?>
