<?

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Aastra XML API Classes - AastraIPPhoneTextScreen
#
# AastraIPPhoneTextScreen object.
#
# Public methods
#
# Inherited from AastraIPPhone
#     setTitle(Title) to setup the title of an object 
#     setDestroyOnExit() to set DestroyonExit parameter to 'yes', 'no' by default (optional)
#     setBeep() to enable a notification beep with the object (optional)
#     addSoftkey(index, label, uri) to add custom softkeys to the object (optional)
#     setRefresh(timeout,URL) to add Refresh parameters to the object (optional)
#     output() to display the object
#
# Specific to the object
#     setText(text) to set the text to be displayed.
#
# Example
#     require_once('AastraIPPhoneTextScreen.class.php');
#     $text = new AastraIPPhoneTextScreen();
#     $text->setTitle('Title');
#     $text->setText('Text to be displayed.');
#     $text->setDestroyOnExit();
#     $text->addSoftkey('1','Label 1','http://myserver.com/script.php?action=1');
#     $text->addSoftkey('6','Exit','SoftKey:Exit');
#     $text->output();
#
###################################################################################################

require_once('AastraIPPhone.class.php');

class AastraIPPhoneTextScreen extends AastraIPPhone {
	var $_text;

	function setText($text)
	{
		$this->_text = $text;
	}

	function render()
	{
		$title = $this->escape($this->_title);
		$text = $this->escape($this->_text);
		$out = '';
		$out .= "<AastraIPPhoneTextScreen";
		if($this->_destroyOnExit == 'yes') $out .= " destroyOnExit=\"yes\"";
		if($this->_beep=='yes') $out .= " Beep=\"yes\"";
		$out .= ">\n";
		$out .= "<Title>{$title}</Title>\n";
		$out .= "<Text>{$text}</Text>\n";
		foreach ($this->_softkeys as $softkey) $out .= $softkey->render();
		$out .= "</AastraIPPhoneTextScreen>\n";
		return $out;
	}
}
?>
