<?php

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Sample php applications using the Aastra XML API Classes
# Aastra SIP Phones Firmware 1.4.1 or better
#
# @param type, type of XML object to display
# type=textmenu AastraIPPhoneTextMenu
# type=textscreen AastraIPPhoneTextScreen
# type=directory AastraIPPhoneDirectory
# type=input AastraIPPhoneInputScreen
# type=status AastraIPPhoneStatus
# type=execute AastraIPPhoneExecute
#
##########################################################

##########################################################
# Retrieve type parameter
$type=$_GET['type'];
$type='inputscreen';

# Display the object
switch($type)
	{
	case 'textmenu':
		require_once('AastraIPPhoneTextMenu.class.php');
		$menu = new AastraIPPhoneTextMenu();
		$menu->setTitle('Title');
#		$menu->setDestroyOnExit();
		$menu->setDeFaultIndex('3');
		$menu->addEntry('Choice 2', 'http://65.205.71.13/php_classes/php_classes_1.4.1/sample.php', 'Value=2');
		$menu->addEntry('Choice 1', 'http://65.205.71.13/php_classes/php_classes_1.4.1/sample.php', 'Value=1');
		$menu->addEntry('Choice 3', 'http://65.205.71.13/php_classes/php_classes_1.4.1/sample.php', 'Value=3');
		$menu->output();


#		$menu = new AastraIPPhoneTextMenu();
#		$menu->setTitle('Title');
#		$menu->setDestroyOnExit();
#		$menu->setDeFaultIndex('3');
#	   	$menu->addEntry('Choice 2', 'http://myserver.com/script.php?choice=2', 'Value=2');
#		$menu->addEntry('Choice 1', 'http://myserver.com/script.php?choice=1', 'Value=1');
#		$menu->addEntry('Choice 3', 'http://myserver.com/script.php?choice=3', 'Value=3');
#		$menu->natsortByName();
#		$menu->addSoftkey('1', 'Label', 'http://myserver.com/script.php?action=1');
#		$menu->addSoftkey('6', 'Exit', 'SoftKey:Exit');
#		$menu->output();


	break;

	case 'textscreen':
		require_once('AastraIPPhoneTextScreen.class.php');
		$text = new AastraIPPhoneTextScreen();
		$text->setTitle('Title');
		$text->setText('Text to be displayed.');
		$text->setDestroyOnExit();
		$text->addSoftkey('1', 'Label', 'http://myserver.com/script.php?action=1');
		$text->addSoftkey('6', 'Exit', 'SoftKey:Exit');
		$text->output();
	break;
	
	case 'inputscreen':
		require_once('AastraIPPhoneInputScreen.class.php');
		$input = new AastraIPPhoneInputScreen();
		$input->setTitle('Test Input');
		$input->setPrompt('Pin code');
		$input->setParameter('password');
		$input->setType('number');
		$input->setURL('http://192.168.0.49/VoIPer/Default.aspx?type=T001&user=TEST&number=');
		$input->setPassword();
		$input->setDestroyOnExit();
		$input->output();

#		$input = new AastraIPPhoneInputScreen();
#		$input->setTitle('Title');
#		$input->setPrompt('Enter your password');
#		$input->setParameter('param');
#		$input->setType('string');
#		$input->setURL('http://myserver.com/script.php');
#		$input->setPassword();
#		$input->setDestroyOnExit();
#		$input->setDefault('Default');
#		$input->addSoftkey('1', 'Label', 'http://myserver.com/script.php?action=1');
#		$input->addSoftkey('6', 'Exit', 'SoftKey:Exit');
#		$input->output();
	break;

	case 'directory':
		require_once('AastraIPPhoneDirectory.class.php');
		$directory = new AastraIPPhoneDirectory();
		$directory->setTitle('Title');
		$directory->setNext('http://myserver.com/script.php?page=2');
		$directory->setPrevious('http://myserver.com/script.php?page=0');
		$directory->setDestroyOnExit();
		$directory->addEntry('John Doe', '200');
		$directory->addEntry('Jane Doe', '201');
		$directory->natsortByName();
		$directory->addSoftkey('1', 'Label', 'http://myserver.com/script.php?action=1');
		$directory->addSoftkey('6', 'Exit', 'SoftKey:Exit');
		$directory->output();
	break;

	case 'status':
		require_once('AastraIPPhoneStatus.class.php');
		$status = new AastraIPPhoneStatus();
		$status->setSession('Session');
		$status->setBeep();
		$status->addEntry('1','Message 1',"alert",5);
		$status->addEntry('2','Message 2');
		$status->output();
	break;

	case 'execute':
		require_once('AastraIPPhoneExecute.class.php');
		$execute = new AastraIPPhoneExecute();
		$execute->addEntry('http://myserver.com/script.php?choice=2');
		$execute->addEntry('Command: Reset');
		$execute->output();
	break;
	}
?>
